/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage.disk;

import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskListener;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class StorageDiskItemPortable
implements IStorageDisk<ItemStack> {
    private final IStorageDisk<ItemStack> parent;
    private final IPortableGrid portableGrid;

    public StorageDiskItemPortable(IStorageDisk<ItemStack> parent, IPortableGrid portableGrid) {
        this.parent = parent;
        this.portableGrid = portableGrid;
    }

    @Override
    public long getCapacity() {
        return this.parent.getCapacity();
    }

    @Override
    public void setSettings(@Nullable IStorageDiskListener listener, IStorageDiskContainerContext context) {
        this.parent.setSettings(listener, context);
    }

    @Override
    public NBTTagCompound writeToNbt() {
        return this.parent.writeToNbt();
    }

    @Override
    public Collection<ItemStack> getStacks() {
        return this.parent.getStacks();
    }

    @Override
    public Collection<StackListEntry<ItemStack>> getEntries() {
        return this.parent.getEntries();
    }

    @Override
    @Nullable
    public StackListResult<ItemStack> insert(@Nonnull ItemStack stack, long size, Action action) {
        long inserted;
        long storedPre = this.parent.getStored();
        StackListResult<ItemStack> remainder = this.parent.insert(stack, size, action);
        if (action == Action.PERFORM && (inserted = this.parent.getCacheDelta(storedPre, size, remainder == null ? 0L : remainder.getCount())) > 0L) {
            this.portableGrid.getItemCache().add(stack, inserted, false);
        }
        return remainder;
    }

    @Override
    @Nullable
    public StackListResult<ItemStack> extract(@Nonnull ItemStack stack, long size, int flags, Action action) {
        StackListResult<ItemStack> extracted = this.parent.extract(stack, size, flags, action);
        if (action == Action.PERFORM && extracted != null) {
            this.portableGrid.getItemCache().remove(extracted.getStack(), extracted.getCount(), false);
        }
        return extracted;
    }

    @Override
    public long getStored() {
        return this.parent.getStored();
    }

    @Override
    public int getPriority() {
        return this.parent.getPriority();
    }

    @Override
    public AccessType getAccessType() {
        return this.parent.getAccessType();
    }

    @Override
    public long getCacheDelta(long storedPreInsertion, long size, long remainder) {
        return this.parent.getCacheDelta(storedPreInsertion, size, remainder);
    }

    @Override
    public String getId() {
        return this.parent.getId();
    }
}

